/*
	Description:
		* Nintendo Mod vault save Includes

	Written By Soloist
	Version 1.0
	Last Updated On 07/24/08

	*************************************************************************************

	Changelog
		Version 1.0
			* Release of the plugin
*/

#include <vault>

public Saving_Init(){}

public SaveXP(id)
{
	if(!is_user_connected(id))
		return PLUGIN_HANDLED;

	new authid[32];
	get_user_authid(id,authid,31);
	new playername[32];
	get_user_name(id, playername,31);

	new vaultkey[64], vaultdata[64];

	// Save their class
	if(PlayerChar[id] != CLASS_NONE)
	{
		format(vaultkey, 63, "nintendoinfo.%s.%s", authid, AllChars[PlayerChar[id]]);
		format(vaultdata, 63, "^"%s^" %d %d %d %d %d %d", playername, PlayerLevel[id][PlayerChar[id]], PlayerXP[id][PlayerChar[id]], PlayerSkill1[id][PlayerChar[id]], PlayerSkill2[id][PlayerChar[id]], PlayerSkill3[id][PlayerChar[id]], PlayerPowerUp[id][PlayerChar[id]]);
		set_vaultdata(vaultkey,vaultdata);
	}

	return PLUGIN_CONTINUE;
}

public SaveXPAll(id)
{
	if(!is_user_connected(id))
		return PLUGIN_HANDLED;

	new authid[32];
	get_user_authid(id,authid,31);
	new playername[32];
	get_user_name(id, playername,31);

	new vaultkey[64], vaultdata[64];

	// Save their classes
	for(new i = 1; i < NumAllChars; i++)
	{
		if(PlayerXP[id][i] != 0)
		{
			format(vaultkey, 63, "nintendoinfo.%s.%s", authid, AllChars[i]);
			format(vaultdata, 63, "^"%s^" %d %d %d %d %d %d", playername, PlayerLevel[id][i], PlayerXP[id][i], PlayerSkill1[id][i], PlayerSkill2[id][i], PlayerSkill3[id][i], PlayerPowerUp[id][i]);
			set_vaultdata(vaultkey,vaultdata);
		}
	}

	return PLUGIN_CONTINUE;
}

public LoadXP(id)
{
	if(!is_user_connected(id))
		return PLUGIN_HANDLED;

	new authid[32];
	get_user_authid(id,authid,31);
	new playername[32];
	get_user_name(id, playername,31);

	new vaultkey[64], vaultdata[64];

	new sXp[33], sLevel[33], sSkill1[33], sSkill2[33], sSkill3[33], sPowerUp[33];
	new iXp, iLevel, iSkill1, iSkill2, iSkill3, iPowerUp;

	for(new i = 1; i <= NumAllChars; i++)
	{

		format(vaultkey, 63, "nintendoinfo.%s.%s", authid, AllChars[i]);
		if(vaultdata_exists(vaultkey))
		{
			get_vaultdata(vaultkey, vaultdata, 63);
			parse(vaultdata, playername, 31, sLevel, 32, sXp, 32, sSkill1, 32, sSkill2, 32, sSkill3, 32, sPowerUp, 32);
			iXp = str_to_num(sXp);
			iLevel = str_to_num(sLevel);
			iSkill1 = str_to_num(sSkill1);
			iSkill2 = str_to_num(sSkill2);
			iSkill3 = str_to_num(sSkill3);
			iPowerUp = str_to_num(sPowerUp);
		}
		else
		{
			iXp = 0;
			iLevel = 0;
			iSkill1 = 0;
			iSkill2 = 0;
			iSkill3 = 0;
			iPowerUp = 0;
		}

		PlayerXP[id][i] = iXp;
		PlayerLevel[id][i] = iLevel;
		PlayerSkill1[id][i] = iSkill1;
		PlayerSkill2[id][i] = iSkill2;
		PlayerSkill3[id][i] = iSkill3;
		PlayerPowerUp[id][i] = iPowerUp;
	}

	return PLUGIN_CONTINUE;
}

public ResetXPAll(id)
{
	new authid[32], playername[32], vaultkey[64];

	get_user_authid(id, authid,31);
	get_user_name(id, playername,31);

	// Save their classes
	for(new i = 1; i < NumAllChars; i++)
	{
		format(vaultkey, 63, "nintendoinfo.%s.%s", authid, AllChars[i]);
		if(vaultdata_exists(vaultkey))
			remove_vaultdata(vaultkey);
	}
}
